<?xml version="1.0"?>

<x:stylesheet version="1.0"
xmlns:x="http://www.w3.org/1999/XSL/Transform">

<x:template match="/">
  <html>
	<head>
		<title>Andrew Tomazos: (G++ 4.6.1 x86-64) C++ Primitive Integer and Built-In Operator Type Coecion and Result</title>
		<style type="text/css">
			p {font-size:small}
			td,th {font-size:x-small}
		</style>
	</head>

  <body>
    <h1>C++ Primitive Integer and Built-In Operator Type Coecion and Result</h1>
<p>Abstract: We look at a concrete implementation of the C++ primitive
integer types and the resultant type and value of some of the unary and binary
builtin operators. </p>

<p>(When we refer to C++ from now on we are talking about the
GNU C++ compiler behavior as executed on x86-64.  Specifically: “g++
(Ubuntu/Linaro 4.6.1-9ubuntu3) 4.6.1”)</p>

<p>Background: The set of all integers is infinite (…-3,-2,-1,0,1,2,3…). 
In C++ there is no built-in type that can hold the full-range of integers.  There
are eight integer types that vary in bit size (8, 16, 32, 64) and whether or
not they have a sign bit.  Each holds a contiguous subset.</p>

<p>Each of the eight types has a minimum and maximum.  We alias
these types and limits according to the following scheme:</p>

<p>     [signedness][bytesize][limit]</p>

<p>Where:</p>

<p>signedness is “s” for signed and “u” for unsigned.</p>

<p>bytesize is 1,2,4 or 8.</p>

<p>limit is “” in the case of the type name, or “min” for
minimum integer value of type, or “max” for maximum value of type.</p>

<p>For example: </p>

<p>u2max is the maximum value of an unsigned 16 bit integer</p>

<p>s8 is the signed 64 bit integer type</p>

<p>s1min is the minimum value of the signed 8 bit integer type</p>

<p>ie</p>

<p>    typedef signed char s1;</p>

<p>    const s1 s1min = 0x80;</p>

<p>    const s1 s1max = 0x7F;</p>

<p></p>

<p>    typedef unsigned char u1;</p>

<p>    const u1 u1min = 0x00u;</p>

<p>    const u1 u1max = 0xFFu;</p>

<p></p>

<p>    typedef signed short int s2;</p>

<p>    const s2 s2min = 0x8000;</p>

<p>    const s2 s2max = 0x7FFF;</p>

<p></p>

<p>    typedef unsigned short int u2;</p>

<p>    const u2 u2min = 0x0000u;</p>

<p>    const u2 u2max = 0xFFFFu;</p>

<p></p>

<p>    typedef signed int s4;</p>

<p>    const s4 s4min = 0x80000000;</p>

<p>    const s4 s4max = 0x7FFFFFFF;</p>

<p></p>

<p>    typedef unsigned int u4;</p>

<p>    const u4 u4min = 0x00000000u;</p>

<p>    const u4 u4max = 0xFFFFFFFFu;</p>

<p></p>

<p>    typedef signed long long int s8;</p>

<p>    const s8 s8min = 0x8000000000000000ull;</p>

<p>    const s8 s8max = 0x7FFFFFFFFFFFFFFFull;</p>

<p></p>

<p>    typedef unsigned long long int u8;</p>

<p>    const u8 u8min = 0x0000000000000000ull;</p>

<p>    const u8 u8max = 0xFFFFFFFFFFFFFFFFull;</p>

<p>Given a unary or binary operator that can be applied to
integer types (for example addition) we are interested to know what the
resultant type (type coercion) and value of its evaluation</p>

<p>For example: if we add an s2 with value -3 to a u1 of value
5:</p>

<p>   s2(-3) + u1(5)</p>

<p>what will be the type and value of this expression?</p>

<p>It would be impractical to test every possible combination
of operator, operand type(s) and operand value(s), so for each operand type we
will test only a subset of possible operand values.  That being the smallest
subset that contains the types minimum, maximum, 0, 1 and -1 (signed only).</p>

<p>The results are as follows:</p>

<p></p>
	<x:for-each select="operators/operator">
	<h2><x:value-of select="@name"/>: <x:value-of select="@signature"/></h2>
	<h3>Type Only</h3>
	<x:for-each select="unary">
    <table border="1">
      <tr bgcolor="#9acd32">
        <th>Operand</th>
	<th>Type</th>
      </tr>
	<x:for-each select="operand">
        <tr>
          <td><x:value-of select="@name"/></td>
		<x:call-template name="cell">
			<x:with-param name="typeorvalue">type</x:with-param>
		</x:call-template>
        </tr>
	</x:for-each>

    </table>
	</x:for-each>
	<x:for-each select="binary">
    <table border="1">
      <tr bgcolor="#9acd32">
        <th>Operand</th>
	<x:for-each select="operand1[1]/operand2">
		<th><x:value-of select="@name"/></th>
	</x:for-each>
      </tr>
	<x:for-each select="operand1">
        <tr>
          <td bgcolor="#9acd32"><x:value-of select="@name"/></td>
	  <x:for-each select="operand2">
		<x:call-template name="cell">
			<x:with-param name="typeorvalue">type</x:with-param>
		</x:call-template>
	  </x:for-each>
        </tr>
	</x:for-each>

    </table>
	</x:for-each>
	<h3>Type and Value</h3>
	<x:for-each select="unary">
    <table border="1">
      <tr bgcolor="#9acd32">
        <th>Operand</th>
	<th>Type (Value)</th>
      </tr>
	<x:for-each select="operand">
        <tr>
          <td><x:value-of select="@name"/></td>
		<x:call-template name="cell">
			<x:with-param name="typeorvalue">value</x:with-param>
		</x:call-template>
        </tr>
	</x:for-each>

    </table>
	</x:for-each>
	<x:for-each select="binary">
    <table border="1">
      <tr bgcolor="#9acd32">
        <th>Operand</th>
	<x:for-each select="operand1[1]/operand2">
		<th><x:value-of select="@name"/></th>
	</x:for-each>
      </tr>
	<x:for-each select="operand1">
        <tr>
          <td bgcolor="#9acd32"><x:value-of select="@name"/></td>
	  <x:for-each select="operand2">
		<x:call-template name="cell">
			<x:with-param name="typeorvalue">value</x:with-param>
		</x:call-template>
	  </x:for-each>
        </tr>
	</x:for-each>

    </table>
	</x:for-each>

	</x:for-each>
  </body>
  </html>
</x:template>

<x:template name="cell">
	<x:param name="typeorvalue"/>
	<td>
		<x:if test="contains(compileoutput,'sign-compare')">
			<x:attribute name="bgcolor">#FFFF00</x:attribute>
		</x:if>
		<x:choose>
			<x:when test="contains(status,'fail')">
				<x:attribute name="bgcolor">#FF0000</x:attribute>
				fail
			</x:when>
			<x:when test="(output/@value) = (output/@pyval)"> 
				<x:value-of select="output/@type"/>
				<x:if test="$typeorvalue = 'value'">
					(<x:value-of select="output/@value"/>)
				</x:if>
			</x:when>
			<x:otherwise>
				<x:attribute name="bgcolor">#7F7FFF</x:attribute>
				<x:value-of select="output/@type"/>
				<x:if test="$typeorvalue = 'value'">
					(<x:value-of select="output/@value"/>)
				</x:if>
			</x:otherwise>
		</x:choose>
	</td>
</x:template>

</x:stylesheet>

