#pragma once
#include "primitives.h"
#include "stdio.h"

using namespace asl;

template<class T>
void printtype(T t)
{
        printf("\"unknown\",\"?\"");

};

#define IMPL_printtype(Tx,Pf) template <> void printtype<Tx>(Tx t) { printf("\"%s\",\"" #Pf "\"", #Tx, t); }

IMPL_printtype(s1,%d);
IMPL_printtype(u1,%u);
IMPL_printtype(s2,%d);
IMPL_printtype(u2,%u);
IMPL_printtype(s4,%d);
IMPL_printtype(u4,%u);
IMPL_printtype(s8,%lld);
IMPL_printtype(u8,%llu);

template <> void printtype<bool>(bool t) { printf("\"bool\",\"%s\"", (t ? "true" : "false")); }

#define EVAL1(t,x,op) void f(t a) { printtype(op a); };  int main() { f(x); }
#define EVAL2(t1,x1,op,t2,x2) void f(t1 a, t2 b) { printtype(a op b); };  int main() { f(x1,x2); }

